<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\EmailVerification;

use DateTime;
use Erlage\Photogram\System;
use Erlage\Photogram\Settings;
use Erlage\Photogram\Constants\ServerConstants;
use Erlage\Photogram\Data\Models\AbstractModel;
use Erlage\Photogram\Data\Tables\User\UserEmailVerificationTable;

final class UserEmailVerificationModel extends AbstractModel implements InterfaceUserEmailVerificationGetter
{
    /**
     * getter interface
     */
    use TraitUserEmailVerificationGetters;

    public function getTableClassName(): string
    {
        return UserEmailVerificationTable::erlClass();
    }

    public function isExpired(): bool
    {
        return UserEmailVerificationEnum::META_IS_EXPIRED_YES == $this -> getMetaIsExpired();
    }

    /**
     * tells whether stamp is ready to be marked as expired
     */
    public function isObsolute(): bool
    {
        $initialStamp = new DateTime($this -> getStampRegistration());

        $currentStamp = new DateTime(System::isoDateTime());

        $difference = $currentStamp -> diff($initialStamp);

        return $difference -> h >= Settings::getInt(ServerConstants::SS_INT_OTP_LIFETIME_IN_HOURS);
    }
}
